// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_EMUTIME_H
#define HW_EMUTIME_H

//AI
WORD RTC_2_LENGTH_32(QWORD rtc);
WORD RTC_2_LENGTH_48(QWORD rtc);
QWORD LENGTH_2_RTC_32(DWORD length);
QWORD LENGTH_2_RTC_48(DWORD length);
WORD CYCLES_2_LENGTH_32(QWORD cycles);
WORD CYCLES_2_LENGTH_48(QWORD cycles);
QWORD LENGTH_2_CYCLES_32(DWORD length);
QWORD LENGTH_2_CYCLES_48(DWORD length);
DWORD RTC_2_AISCNT(QWORD rtc); //(rtc * 48000) / RTCF
DWORD CYCLES_2_AISCNT(QWORD cycles);	//(cycles * 48000) / BOGOMIPS //(cycles << 1) / 37125
QWORD AISCNT_2_RTC(DWORD aiscnt); //(aiscnt * RTCF) / 48000
QWORD AISCNT_2_CYCLES(DWORD aiscnt); //(aiscnt * BOGOMIPS) / 48000 //(aiscnt * 37125) >> 1
#define FREQED(func) ((aicr & AICR_DSR) ? func##_32 : func##_48)  //fugly. see MODED.

//VI
struct VIFRAME {
	ULI rawframe;	//((time*LINES_PER_SECOND)/freq)/LINES_PER_FRAME
	WORD newline;	//((time*LINES_PER_SECOND)/freq)%LINES_PER_FRAME + 1
};
void RTC_2_VIFRAME_PAL(QWORD rtc, VIFRAME *vif);
void RTC_2_VIFRAME_NTSC(QWORD rtc, VIFRAME *vif);
QWORD RAWFRAME_2_RTC_PAL(QWORD rawframe);  //(rawframe*RTCF)/25
QWORD RAWFRAME_2_RTC_NTSC(QWORD rawframe);  //(rawframe*RTCF)/30
void CYCLES_2_VIFRAME_PAL(QWORD cycles, VIFRAME *vif);
void CYCLES_2_VIFRAME_NTSC(QWORD cycles, VIFRAME *vif);
QWORD RAWFRAME_2_CYCLES_PAL(QWORD rawframe); //rawframe*(BOGOMIPS/25)
QWORD RAWFRAME_2_CYCLES_NTSC(QWORD rawframe); //rawframe*(BOGOMIPS/30)
QWORD LINES_2_RTC_PAL(DWORD lines); //(lines*RTCF)/(25*625)
QWORD LINES_2_RTC_NTSC(DWORD lines); //(lines*RTCF)/(30*525)
QWORD LINES_2_CYCLES_PAL(DWORD lines); //lines*(BOGOMIPS/(25*625))
QWORD LINES_2_CYCLES_NTSC(DWORD lines); //lines*(BOGOMIPS/(30*525))
/*QWORD PIXELS_2_RTC_PAL(DWORD pixels); //(pixels*RTCF)/(25*625*640)
QWORD PIXELS_2_RTC_NTSC(DWORD pixels); //(pixels*RTCF)/(30*525*640)
QWORD PIXELS_2_CYCLES_PAL(DWORD pixels); //(pixels*BOGOMIPS)/(25*625*640)
QWORD PIXELS_2_CYCLES_NTSC(DWORD pixels); //(pixels*BOGOMIPS)/(30*525*640)*/
#define MODED(func) (h->vi.mode == 1 ? func##_PAL : func##_NTSC)

#endif	//HW_EMUTIME_H
